# Generated by ChatGPT
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion

class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(max_length=140)),
                ('slug', models.SlugField(blank=True, max_length=160, unique=True)),
                ('short_description', models.TextField()),
                ('who_its_for', models.TextField(blank=True)),
                ('benefits', models.TextField(blank=True)),
                ('icon', models.CharField(default='🩺', max_length=60)),
                ('is_featured', models.BooleanField(default=False)),
                ('sort_order', models.PositiveIntegerField(default=0)),
            ],
            options={'ordering': ['sort_order', 'title']},
        ),
        migrations.CreateModel(
            name='Testimonial',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(blank=True, help_text='Optional (can be anonymized)', max_length=120)),
                ('relation', models.CharField(blank=True, help_text='e.g., Son, Daughter, Patient', max_length=120)),
                ('content', models.TextField()),
                ('is_published', models.BooleanField(default=True)),
            ],
            options={'ordering': ['-created_at']},
        ),
        migrations.CreateModel(
            name='BlogPost',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(max_length=200)),
                ('slug', models.SlugField(blank=True, max_length=220, unique=True)),
                ('excerpt', models.TextField(blank=True)),
                ('body', models.TextField()),
                ('cover_image', models.ImageField(blank=True, null=True, upload_to='blog/')),
                ('is_published', models.BooleanField(default=True)),
                ('published_at', models.DateTimeField(blank=True, null=True)),
            ],
            options={'ordering': ['-published_at', '-created_at']},
        ),
        migrations.CreateModel(
            name='CareerPosition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(max_length=160)),
                ('role_type', models.CharField(choices=[('nurse', 'Nurse'), ('caregiver', 'Caregiver'), ('admin', 'Admin/Support')], default='caregiver', max_length=20)),
                ('location', models.CharField(blank=True, max_length=120)),
                ('requirements', models.TextField()),
                ('is_open', models.BooleanField(default=True)),
            ],
            options={'ordering': ['-created_at']},
        ),
        migrations.CreateModel(
            name='Enquiry',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('full_name', models.CharField(max_length=140)),
                ('phone', models.CharField(max_length=30)),
                ('email', models.EmailField(blank=True, max_length=254)),
                ('enquiry_type', models.CharField(choices=[('care', 'Request Care'), ('partner', 'Partnership / Corporate'), ('career', 'Career'), ('general', 'General'), ('mental_pickup', 'Mental Health Facility Transfer (Non-emergency)'), ('event_coverage', 'Event Medical Coverage')], default='care', max_length=30)),
                ('message', models.TextField()),
                ('location', models.CharField(blank=True, max_length=160)),
                ('preferred_contact_time', models.CharField(blank=True, max_length=80)),
                ('is_resolved', models.BooleanField(default=False)),
            ],
            options={'ordering': ['-created_at']},
        ),
        migrations.CreateModel(
            name='CareerApplication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('full_name', models.CharField(max_length=140)),
                ('phone', models.CharField(max_length=30)),
                ('email', models.EmailField(max_length=254)),
                ('cv', models.FileField(upload_to='applications/')),
                ('notes', models.TextField(blank=True)),
                ('position', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='website.careerposition')),
            ],
            options={'ordering': ['-created_at']},
        ),
        migrations.CreateModel(
            name='CareRequest',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('request_type', models.CharField(choices=[('home_care', 'Home Care'), ('post_hospital', 'Post-hospital Recovery'), ('elderly', 'Elderly / Geriatric Care'), ('mental_transfer', 'Mental Health Patient Transfer (Non-emergency)'), ('event_medical', 'Event Medical Coverage'), ('other', 'Other')], default='home_care', max_length=30)),
                ('status', models.CharField(choices=[('new', 'New'), ('assessment', 'Assessment'), ('matched', 'Caregiver Matched'), ('active', 'Active'), ('completed', 'Completed'), ('cancelled', 'Cancelled')], default='new', max_length=20)),
                ('full_name', models.CharField(max_length=140)),
                ('phone', models.CharField(max_length=30)),
                ('email', models.EmailField(blank=True, max_length=254)),
                ('location', models.CharField(blank=True, max_length=160)),
                ('patient_age', models.PositiveIntegerField(blank=True, null=True)),
                ('care_needs', models.TextField(help_text='Brief description of care needs')),
                ('preferred_start_date', models.DateField(blank=True, null=True)),
                ('schedule_notes', models.CharField(blank=True, help_text='e.g., Day, Night, 24/7, Weekends', max_length=220)),
                ('preference_notes', models.TextField(blank=True, help_text='Language/culture preferences, gender preference, etc.')),
                ('risk_notes', models.TextField(blank=True, help_text='Any safety or clinical considerations (non-emergency)')),
            ],
            options={'ordering': ['-created_at']},
        ),
        migrations.CreateModel(
            name='CaregiverProfile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('phone', models.CharField(blank=True, max_length=30)),
                ('location', models.CharField(blank=True, max_length=160)),
                ('skills', models.TextField(blank=True, help_text='Comma-separated skills/certifications')),
                ('availability', models.TextField(blank=True, help_text='e.g., Mon–Fri (Day), Weekends, Night shifts')),
                ('is_active', models.BooleanField(default=True)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='caregiver_profile', to=settings.AUTH_USER_MODEL)),
            ],
            options={'ordering': ['-created_at']},
        ),
        migrations.CreateModel(
            name='SupportTicket',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_id', models.CharField(db_index=True, max_length=12, unique=True)),
                ('secret', models.CharField(db_index=True, max_length=36)),
                ('full_name', models.CharField(max_length=120)),
                ('email', models.EmailField(blank=True, max_length=254)),
                ('phone', models.CharField(blank=True, max_length=40)),
                ('subject', models.CharField(default='Support Request', max_length=180)),
                ('status', models.CharField(choices=[('open', 'Open'), ('pending', 'Pending'), ('closed', 'Closed')], default='open', max_length=20)),
                ('priority', models.CharField(default='normal', max_length=20)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('sla_minutes', models.PositiveIntegerField(default=15)),
                ('due_at', models.DateTimeField(blank=True, null=True)),
                ('first_response_at', models.DateTimeField(blank=True, null=True)),
                ('last_client_message_at', models.DateTimeField(blank=True, null=True)),
                ('last_staff_message_at', models.DateTimeField(blank=True, null=True)),
                ('assigned_to', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='assigned_tickets', to=settings.AUTH_USER_MODEL)),
            ],
            options={'ordering': ['-created_at']},
        ),
        migrations.CreateModel(
            name='SupportMessage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sender', models.CharField(default='client', max_length=20)),
                ('message', models.TextField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('ticket', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='messages', to='website.supportticket')),
            ],
            options={'ordering': ['created_at']},
        ),
        migrations.CreateModel(
            name='StaffNotification',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('kind', models.CharField(default='support', max_length=40)),
                ('title', models.CharField(max_length=140)),
                ('body', models.TextField(blank=True)),
                ('url', models.CharField(blank=True, max_length=240)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('is_read', models.BooleanField(default=False)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='staff_notifications', to=settings.AUTH_USER_MODEL)),
            ],
            options={'ordering': ['-created_at']},
        ),
        migrations.CreateModel(
            name='CareAssignment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('proposed', 'Proposed'), ('accepted', 'Accepted'), ('active', 'Active'), ('completed', 'Completed'), ('cancelled', 'Cancelled')], default='proposed', max_length=20)),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('notes', models.TextField(blank=True)),
                ('care_request', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='assignments', to='website.carerequest')),
                ('caregiver', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='assignments', to='website.caregiverprofile')),
            ],
            options={'ordering': ['-created_at']},
        ),
    ]
