from django.core.management.base import BaseCommand
from website.models import Service, Testimonial, CareerPosition

class Command(BaseCommand):
    help = "Seed demo content (services/testimonials/careers) for first run."

    def handle(self, *args, **kwargs):
        services = [
            ("Professional Home Nursing Care", "Skilled nursing services by qualified professionals.", "🩺"),
            ("Elderly & Companion Care", "Companionship and support for older adults.", "👵🏽"),
            ("Post-Hospital & Recovery Care", "Support after discharge to aid healing.", "🩹"),
            ("Personal Care Assistance", "Daily living support with dignity and privacy.", "🧼"),
            ("Palliative & Comfort Care", "Comfort-focused care and emotional support.", "🤍"),
            ("Mental Health Patient Transfer", "Non-emergency patient pickup/transfer to a facility.", "🚐"),
            ("Event Medical Coverage Team", "On-site medical support for events.", "⛑️"),
        ]
        for title, desc, icon in services:
            Service.objects.get_or_create(
                title=title,
                defaults={
                    "short_description": desc,
                    "who_its_for": "Families, patients, and partners who need reliable support.",
                    "benefits": "Safety, professionalism, and compassionate care.",
                    "icon": icon,
                    "is_featured": True,
                    "sort_order": 10,
                },
            )

        Testimonial.objects.get_or_create(
            name="A grateful family (Anonymized)",
            defaults={
                "quote": "The team was professional, kind, and always on time. Our loved one felt safe and respected.",
                "is_published": True,
            },
        )

        CareerPosition.objects.get_or_create(
            title="Caregiver",
            defaults={"role_type": "caregiver", "location": "Lagos", "requirements": "Relevant training/experience, empathy, and reliability."},
        )
        CareerPosition.objects.get_or_create(
            title="Registered Nurse",
            defaults={"role_type": "nurse", "location": "Lagos", "requirements": "Valid nursing license, clinical skills, and strong communication."},
        )

        self.stdout.write(self.style.SUCCESS("Demo content seeded."))
