from django.conf import settings
from django.conf.urls.static import static
from django.contrib import admin
from django.urls import path, include
from django.views.generic import TemplateView

urlpatterns = [
    path("admin/", admin.site.urls),
    path("", include(("website.urls", "website"), namespace="website")),
]

if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)


# PWA endpoints at root scope
urlpatterns += [
    path("manifest.json", TemplateView.as_view(template_name="website/pwa/manifest.json", content_type="application/manifest+json")),
    path("sw.js", TemplateView.as_view(template_name="website/pwa/sw.js", content_type="application/javascript")),
]
